package cn.com.duiba.quanyi.center.api.remoteservice.qy.ccbLife.business;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.ccbLife.BusinessUserDto;
import cn.com.duiba.quanyi.center.api.param.qy.ccbLife.business.BusinessUserSearchParam;
import java.util.List;

/**
 * 商户关联用户表
 * @author kjj mybatis generator 
 * @date 2024-02-22
 */
@AdvancedFeignClient
public interface RemoteBusinessUserService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 商户关联用户集合
     */
    List<BusinessUserDto> selectPage(BusinessUserSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(BusinessUserSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 商户关联用户
     */
    BusinessUserDto selectById(Long id);

    /**
     * 新增
     * @param dto 商户关联用户
     * @return 执行结果
     */
    int insert(BusinessUserDto dto);

    /**
     * 更新
     * @param dto 商户关联用户
     * @return 影响行数
     */
    int update(BusinessUserDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}