package cn.com.duiba.quanyi.center.api.param.ccbLife;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.annotation.Nullable;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * @author xjl
 * @date 2023/11/25 15:24
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class StoreManagerPageQueryParam extends PageQuery {

    private static final long serialVersionUID = 1521497090176123064L;

    /**
     * id
     */
    private Set<Long> ids;

    /**
     * 商户号
     */
    private String businessNum;

    /**
     * 门店号
     */
    private String shopNum;

    /**
     * 商户名
     */
    private String businessName;

    /**
     * 门店名
     */
    private String shopName;

    /**
     * 门店号集合
     */
    private Set<String> shopNums;

    /**
     * 创建开始时间
     */
    private Date gmtCreateBegin;

    /**
     * 创建结束时间
     */
    private Date gmtCreateOver;

    /**
     * 更新开始时间
     */
    private Date gmtModifiedBegin;

    /**
     * 更新结束时间
     */
    private Date gmtModifiedOver;


    /**
     * 商户号集合
     */
    @Nullable
    private List<String> businessNumList;

    /**
     * 分行类型
     */
    private Integer type = 1;
}
