package cn.com.duiba.quanyi.center.api.remoteservice.ccbLife;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.ccbLife.BusinessDto;
import cn.com.duiba.quanyi.center.api.param.ccbLife.BusinessSearchParam;
import java.util.List;

/**
 * 商户表
 * @author kjj mybatis generator 
 * @date 2024-02-22
 */
@AdvancedFeignClient
public interface RemoteBusinessService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 商户集合
     */
    List<BusinessDto> selectPage(BusinessSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(BusinessSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 商户
     */
    BusinessDto selectById(Long id);

    /**
     * 新增
     * @param dto 商户
     * @return 执行结果
     */
    int insert(BusinessDto dto);

    /**
     * 更新
     * @param dto 商户
     * @return 影响行数
     */
    int update(BusinessDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}