package cn.com.duiba.quanyi.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.VerifyNotifyDto;
import cn.com.duiba.quanyi.center.api.param.coupon.VerifyNotifySearchParam;
import java.util.List;

/**
 * 核销通知表
 * @author kjj mybatis generator 
 * @date 2024-02-04
 */
@AdvancedFeignClient
public interface RemoteVerifyNotifyService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 核销通知集合
     */
    List<VerifyNotifyDto> selectPage(VerifyNotifySearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(VerifyNotifySearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 核销通知
     */
    VerifyNotifyDto selectById(Long id);

    /**
     * 新增
     * @param dto 核销通知
     * @return 执行结果
     */
    Long insert(VerifyNotifyDto dto);

    /**
     * 更新
     * @param dto 核销通知
     * @return 影响行数
     */
    int update(VerifyNotifyDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);


    /**
     * 更新核销通知
     *
     * @param id     核销通知id
     * @param status 状态
     * @return 影响行数
     */
    int updateStatus(Long id, int status);

}