package cn.com.duiba.quanyi.center.api.remoteservice.qystatistic;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qystatistic.AlipayActivityAmountStatisticDto;
import cn.com.duiba.quanyi.center.api.param.qystatistic.AlipayActivityAmountStatisticSearchParam;
import java.util.List;

/**
 * 支付宝活动金额统计
 * @author kjj mybatis generator 
 * @date 2024-09-13
 */
@AdvancedFeignClient
public interface RemoteAlipayActivityAmountStatisticService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 支付宝活动金额统计集合
     */
    List<AlipayActivityAmountStatisticDto> selectPage(AlipayActivityAmountStatisticSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(AlipayActivityAmountStatisticSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 支付宝活动金额统计
     */
    AlipayActivityAmountStatisticDto selectById(Long id);

    /**
     * 新增
     * @param dto 支付宝活动金额统计
     * @return 执行结果
     */
    int insert(AlipayActivityAmountStatisticDto dto);

    /**
     * 更新
     * @param dto 支付宝活动金额统计
     * @return 影响行数
     */
    int update(AlipayActivityAmountStatisticDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}