package cn.com.duiba.quanyi.center.api.remoteservice.qy.statement;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.statement.StatementDto;
import cn.com.duiba.quanyi.center.api.param.qy.statement.StatementSearchParam;
import java.util.Date;
import java.util.List;

/**
 * 结算单表
 *
 * @author kjj mybatis generator
 * @date 2024-07-18
 */
@AdvancedFeignClient
public interface RemoteStatementService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     *
     * @param param 查询条件
     * @return 结算单集合
     */
    List<StatementDto> selectPage(StatementSearchParam param);


    /**
     * 查询(不分页)
     *
     * @param param 查询条件
     * @return 结算单集合
     */
    List<StatementDto> selectNoPage(StatementSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     *
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(StatementSearchParam param);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结算单
     */
    StatementDto selectById(Long id);

    /**
     * 新增
     *
     * @param dto 结算单
     * @return 执行结果
     */
    int insert(StatementDto dto);

    /**
     * 更新
     *
     * @param dto 结算单
     * @return 影响行数
     */
    int update(StatementDto dto);

    /**
     * 物理删除
     *
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);


    /**
     * 初始化结算单号和结算金额
     *
     * @param settlementNo     结算单号
     * @param settlementAmount 结算金额
     * @param id               主键
     * @return 执行结果
     */
    int initSettlementNoAndSettlementAmount(String settlementNo, Long settlementAmount, Long id);

    /**
     * 根据创建时间查询
     *
     * @param createDate 创建时间
     * @return 结算单列表
     */
    List<StatementDto> selectByCreateDate(Date createDate);

}