package cn.com.duiba.quanyi.center.api.param.wx;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * 微信核销数据统计表
 * @author mybatis generator 
 * @date 2024-06-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class WxWriteOffDataStatisticSearchParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = -6718178531888498645L;

    /**
     * 批次号
     */
    private String stockId;

    /**
     * 批次号名称
     */
    private String stockName;

    /**
     * 配置日期 - 开始日期
     */
    private Date startDate;

    /**
     * 配置日期 - 结束日期
     */
    private Date endDate;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 结算主体
     */
    private String settlementEntity;

    /**
     * 配置主体：列表筛选
     */
    private String configEntity;

    /**
     * 运营负责人
     */
    private String operationManagerName;

    /**
     * 月份：只作用于数值变化
     */
    private Date month;

    /**
     * 批次号状态
     */
    private String stockStatus;

    /**
     * 排序字段
     */
    private String sortFiled;

    /**
     * true - DESC
     * FALSE - ASC
     */
    private Boolean desc;
}