package cn.com.duiba.quanyi.center.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityWhiteCustomerDto;
import cn.com.duiba.quanyi.center.api.param.activity.ActivityWhiteCustomerSearchParam;

import java.util.List;

/**
 * 活动导入白名单客户表
 * @author kjj mybatis generator 
 * @date 2024-08-15
 */
@AdvancedFeignClient
public interface RemoteActivityWhiteCustomerService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 活动导入白名单客户集合
     */
    List<ActivityWhiteCustomerDto> selectPage(ActivityWhiteCustomerSearchParam param);

    /**
     * 根据条件查询
     * @param param
     * @return
     */
    List<ActivityWhiteCustomerDto> selectByCondition(ActivityWhiteCustomerSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ActivityWhiteCustomerSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 活动导入白名单客户
     */
    ActivityWhiteCustomerDto selectById(Long id);

    /**
     * 新增
     * @param dto 活动导入白名单客户
     * @return 执行结果
     */
    int insert(ActivityWhiteCustomerDto dto);

    /**
     * 更新
     * @param dto 活动导入白名单客户
     * @return 影响行数
     */
    int update(ActivityWhiteCustomerDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}