package cn.com.duiba.quanyi.center.api.dto.api.doc.result.sync;

import cn.com.duiba.quanyi.center.api.enums.api.ApiKmTypeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * API文档-订单结果-券包-子订单-同步
 * @author lizhi
 * @date 2024/7/17 10:37
 */
@Data
public class ApiDocPkgSubSyncOrderResultDto implements Serializable {
    
    private static final long serialVersionUID = 6627834242388732404L;

    /**
     * 券包子订单号
     */
    private String subOrderNum;

    /**
     * 券包子订单状态
     * @see cn.com.duiba.quanyi.center.api.enums.api.ApiOrderStatusEnum
     */
    private Integer subOrderStatus;

    /**
     * 错误码，业务错误码，一般是业务逻辑的错误码
     */
    private String failCode;

    /**
     * 错误描述
     */
    private String failDesc;

    /**
     * 过期时间，毫秒数，1970.1.1开始的毫秒数
     * ● 商品为卡密时，为卡密的过期时间
     * ● 商品为链接券时，为链接券过期时间
     */
    private Long expireTime;

    /**
     * 卡密类型
     * @see ApiKmTypeEnum
     */
    private Integer kmType;

    /**
     * 卡密code
     */
    private String kmCode;

    /**
     * 卡密密码
     */
    private String kmPassword;

    /**
     * 卡密链接
     */
    private String kmLink;

    /**
     * 优惠券Id
     */
    private String couponId;

    /**
     * 快递公司名称
     */
    private String expressCompanyName;

    /**
     * 快递单号
     */
    private String expressNo;
    
}
