package cn.com.duiba.quanyi.center.api.enums.coupon;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 美团券批次状态
 * 1-立减券
 * 3-满减券
 * 4-折扣券
 * 7-口价券
 */
@Getter
@AllArgsConstructor
public enum MeiTuanCouponTypeEnum {
    DISCOUNT_COUPON(1, "立减券"),
    FULL_REDUCTION_COUPON(3, "满减券"),
    PERCENTAGE_DISCOUNT_COUPON(4, "折扣券"),
    FIXED_PRICE_COUPON(7, "口价券"),
    ;

    private int code;
    private String description;

    /**
     * 根据code获取枚举对象
     * @param code
     * @return
     */
    public static MeiTuanCouponTypeEnum getByCode(int code) {
        for (MeiTuanCouponTypeEnum status : values()) {
            if (status.code == code) {
                return status;
            }
        }
        return null;
    }


}
