package cn.com.duiba.quanyi.center.api.dto.coupon;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 支付宝数币红包活动关联表
 * @author lizhi
 */
@Data
public class AlipayCountCoinsActivityRelationDto implements Serializable {

    private static final long serialVersionUID = 8872513452204311891L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 支付宝数币红包主键, tb_alipay_count_coins_activity.id
     */
    private Long alipayActivityId;

    /**
     * 活动主键, tb_activity.id
     */
    private Long activityId;

    /**
     * 活动奖品主键, tb_activity_prize.id
     */
    private Long activityPrizeId;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     * @see cn.com.duiba.quanyi.center.api.enums.LogicDeleteEnum
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 活动类型：1=白名单领奖、2=兑吧卡密包
     * @see cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum
     */
    private Integer activityType;

    /**
     * 发放开始时间
     */
    private Date grantStartTime;

    /**
     * 发放结束时间
     */
    private Date grantEndTime;

}