package cn.com.duiba.quanyi.center.api.enums.insurance;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2024/3/4 14:06
 */
@Getter
@AllArgsConstructor
public enum InsuranceCompanyBizVersionEnum {
    REN_BAO(1, "人保"),
    TAI_BAO(2, "太保"),
    YUN_YAN(3, "贵州云岩"),
    CHANG_SHA(5, "长沙"),
    LAND(6, "大地保险"),
    GUI_ZHOU_TAI_BAO(7, "贵州太保"),
    ;
    
    private final Integer type;
    
    private final String desc;

    private static final Map<Integer, InsuranceCompanyBizVersionEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(InsuranceCompanyBizVersionEnum::getType, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static InsuranceCompanyBizVersionEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
