package cn.com.duiba.quanyi.center.api.remoteservice.goods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.goods.CardSecretConsumerBindRecordDto;
import cn.com.duiba.quanyi.center.api.param.qy.goods.CardSecretConsumerBindRecordSearchParam;
import java.util.List;

/**
 * 卡密用户绑定关系表
 * @author kjj mybatis generator 
 * @date 2024-09-24
 */
@AdvancedFeignClient
public interface RemoteCardSecretConsumerBindRecordService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 卡密用户绑定关系集合
     */
    List<CardSecretConsumerBindRecordDto> selectPage(CardSecretConsumerBindRecordSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(CardSecretConsumerBindRecordSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 卡密用户绑定关系
     */
    CardSecretConsumerBindRecordDto selectById(Long id);

    /**
     * 新增
     * @param dto 卡密用户绑定关系
     * @return 执行结果
     */
    int insert(CardSecretConsumerBindRecordDto dto);

    /**
     * 更新
     * @param dto 卡密用户绑定关系
     * @return 影响行数
     */
    int update(CardSecretConsumerBindRecordDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据短链查询绑定记录
     * @param linkCode
     * @return
     */
    CardSecretConsumerBindRecordDto selectByLinkCode(String linkCode);
}