package cn.com.duiba.quanyi.center.api.remoteservice.goods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.api.GoodsOrderShortUrlExpirePushDto;
import cn.com.duiba.quanyi.center.api.param.qy.api.GoodsOrderShortUrlExpirePushSearchParam;
import java.util.List;

/**
 * API订单短链过期推送表
 * @author kjj mybatis generator 
 * @date 2024-08-16
 */
@AdvancedFeignClient
public interface RemoteGoodsOrderShortUrlExpirePushService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return API订单短链过期推送集合
     */
    List<GoodsOrderShortUrlExpirePushDto> selectPage(GoodsOrderShortUrlExpirePushSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(GoodsOrderShortUrlExpirePushSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return API订单短链过期推送
     */
    GoodsOrderShortUrlExpirePushDto selectById(Long id);

    /**
     * 新增
     * @param dto API订单短链过期推送
     * @return 执行结果
     */
    int insert(GoodsOrderShortUrlExpirePushDto dto);

    /**
     * 更新
     * @param dto API订单短链过期推送
     * @return 影响行数
     */
    int update(GoodsOrderShortUrlExpirePushDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 批量删除id 真删除
     * @param ids 主键id集合
     * @return 插入结果
     */
    int batchDelete(List<Long> ids);

    /**
     * 根据goodsOrderNo查询商品订单号
     * @param goodsOrderNo 商品订单号
     * @return GoodsOrderShortUrlExpirePushDto
     */
    GoodsOrderShortUrlExpirePushDto selectByGoodsOrderNo(String goodsOrderNo);



}