package cn.com.duiba.quanyi.center.api.dto.mall.order;

import java.io.Serializable;
import java.util.Date;

import cn.com.duiba.quanyi.center.api.dto.mall.address.MallUserAddressDto;
import lombok.Data;

/**
 * 商城订单
 * @author mybatis generator 
 * @date 2024-05-25
 */
@Data
public class MallOrderDto implements Serializable {
     
    private static final long serialVersionUID = 17166182119324503L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 商城订单编号
     */
    private String mallOrderNo;

    /**
     * 用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 商品配置ID（入口位置）
     */
    private Long confId;

    /**
     * 商城商品spuId
     */
    private Long mallSpuId;

    /**
     * 商城商品skuId
     */
    private Long mallSkuId;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 奖品ID
     */
    private Long prizeId;

    /**
     * 购买数量
     */
    private Integer quantity;

    /**
     * 商品库spu类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     */
    private Integer spuType;

    /**
     * 售卖价，单位分
     */
    private Long sellPrice;

    /**
     * 兑换价，单位分
     */
    private Long takePrice;

    /**
     * 兑换方式
     * @see cn.com.duiba.quanyi.center.api.enums.activity.TakeTypeEnum
     */
    private Integer takeType;

    /**
     * 单价，单位分
     */
    private Long unitPrice;

    /**
     * 订单价格，单位分
     */
    private Long orderPrice;

    /**
     * 收货地址
     */
    private Long addressId;

    /**
     * 地址快照
     */
    private MallUserAddressDto addressSnapshot;

    /**
     * 支付订单号
     */
    private String bizOrderNo;

    /**
     * 是否支付成功，仅用于搜索
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer paySuccess;

    /**
     * 领取参数快照
     */
    private MallOrderTakeParamDto takeParamSnapshot;
}