package cn.com.duiba.quanyi.center.api.dto.statistic;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 保司积分发放统计
 * @author mybatis generator 
 * @date 2024-07-22
 */
@Data
public class InsuranceCreditsGrantStatisticDto implements Serializable {
     
    private static final long serialVersionUID = 17216309571747901L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 统计日期
     */
    private Date curDate;

    /**
     * 积分发放汇总
     */
    private Long sumGrantAmount;

    /**
     * 积分兑换汇总(老系统)
     */
    private Long oldTakeAmount;

    /**
     * 积分兑换明细(微信零钱)
     */
    private Long wxTakeAmount;

    /**
     * 积分兑换明细(银行卡转账)
     */
    private Long bankTakeAmount;

    /**
     * 积分兑换明细(大额微信零钱)
     */
    private Long wxMoreTakeAmount;

    /**
     * 积分兑换明细(车险商城)
     */
    private Long mallTakeAmount;

    /**
     * 当日累计未兑换积分(老系统)
     */
    private Long unUsedAmountOld;

    /**
     * 当日累计未兑换积分(新系统)
     */
    private Long unUsedAmount;
}