package cn.com.duiba.quanyi.center.api.enums.coupon.autocreate;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;

/**
 * @author xuzhigang
 * @date 2024/6/24 11:24
 **/
@Getter
@AllArgsConstructor
public enum WechatTagUserBehaviorTypeEnum {
    NOT_SPECIFIED(1, "不指定"),

    TRADE_NUM_RANGE(2, "交易笔数区间"),

    TRADE_AMOUNT_RANGE(3, "交易金额区间"),
    ;

    private final int type;

    private final String desc;

    public static boolean contains(int type) {
        return Arrays.stream(values()).anyMatch(e -> e.getType() == type);
    }

}
