package cn.com.duiba.quanyi.center.api.dto.qystatistic;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 扫描订单表
 * @author mybatis generator 
 * @date 2024-09-26
 */
@Data
public class GoodsOrderScanDto implements Serializable {
     
    private static final long serialVersionUID = 17273462851935530L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 商品库订单业务主键
     */
    private Long goodsBizId;

    /**
     * 商品库订单业务类型, 1-白名单活动，2-商品包
     */
    private Integer goodsBizType;

    /**
     * 订单号
     */
    private String goodsOrderNo;

    /**
     * 商品类型
     */
    private Integer spuType;

    /**
     * 订单价格，单位分
     */
    private Long orderPrice;

    /**
     * 订单状态, 1-处理中，2-成功，3-失败, 4-异常
     */
    private Integer orderStatus;

    /**
     * 商品库订单号
     */
    private String orderNo;

    /**
     * 短链
     */
    private String shortUrl;

    /**
     * 发放方式：1-直充，2-短链
     */
    private Integer grantType;

    /**
     * 发放的批次表主键
     */
    private Long couponId;

    /**
     * 发放面额
     */
    private Long couponAmount;

    /**
     * 业务单号
     */
    private String bizOrderNo;

    /**
     * 短链失效时间
     */
    private Date shortUrlExpireTime;

    /**
     * 关闭原因
     */
    private String closeReason;

    /**
     * 客户单号
     */
    private String thirdOrderId;

    /**
     * 调用商品库发放参数
     */
    private String accountInfo;

    /**
     * goodsOrder的创建时间
     */
    private Date goodsOrderGmtCreate;

    /**
     * goodsOrder的修改时间
     */
    private Date goodsOrderGmtModified;

    /**
     * 奖品ID
     */
    private Long prizeId;

    /**
     * 兑吧单号
     */
    private String mainOrderNum;
}