package cn.com.duiba.quanyi.center.api.remoteservice.qystatistic;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qystatistic.GoodsOrderScanDto;

import java.util.Date;
import java.util.List;

/**
 * 扫描订单表
 *
 * @author kjj mybatis generator
 * @date 2024-09-26
 */
@AdvancedFeignClient
public interface RemoteGoodsOrderScanService {

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 扫描订单
     */
    GoodsOrderScanDto selectById(Long id);

    /**
     * 新增
     *
     * @param dto 扫描订单
     * @return 执行结果
     */
    int insert(GoodsOrderScanDto dto);

    /**
     * 更新
     *
     * @param dto 扫描订单
     * @return 影响行数
     */
    int update(GoodsOrderScanDto dto);

    /**
     * 物理删除
     *
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 分页查询指定创建时间区间和业务的订单
     *
     * @param startTime    开始时间
     * @param endTime      结束时间
     * @param goodsBizId   goods biz id
     * @param goodsBizType goods biz type
     * @param lastId       上次查询最后一个ID
     * @param pageSize     每次查询最多查询多少条
     * @return 订单详情集合
     */
    List<GoodsOrderScanDto> selectPageByGoodsOrderGmtCreateAndBiz(Date startTime, Date endTime, Long goodsBizId, Integer goodsBizType, Long lastId, Integer pageSize);

    /**
     * 分页查询指定更新时间区间、业务和状态的订单
     *
     * @param startTime       开始时间
     * @param endTime         结束时间
     * @param goodsBizId      goods biz id
     * @param goodsBizType    goods biz type
     * @param orderStatusList order status list
     * @param lastId          上次查询最后一个ID
     * @param pageSize        每次查询最多查询多少条
     * @return 订单详情集合
     */
    List<GoodsOrderScanDto> selectPageByGoodsOrderGmtModifiedAndBizAndStatus(Date startTime, Date endTime, Long goodsBizId, Integer goodsBizType, List<Integer> orderStatusList, Long lastId, Integer pageSize);

}