package cn.com.duiba.quanyi.center.api.param.insurance;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2024/3/5 14:02
 */
@Data
public class InsuranceTakeGrantParam implements Serializable {
    
    private static final long serialVersionUID = -4124187868794445013L;

    /**
     * 支付宝openId, 映射支付宝user_id
     * 请使用open_id，后续user_id将不支持新接入使用，存量已对接的也将逐步回收。
     */
    private String alipayOpenId;

    /**
     * 支付宝登录账号，邮箱格式
     */
    private String alipayLoginId;

    /**
     * 支付宝登录账号，手机号格式
     */
    private String alipayPhoneId;

    /**
     * 查询支付宝openId时，支付宝返回的账号
     */
    private String alipayOutputAccount;
    
    /**
     * 微信用户openId
     */
    private String wxOpenId;

    /**
     * 微信公众号、小程序AppID
     */
    private String wxAppId;

    /**
     * 转账金额，单位：分
     * ● 商品为微信到零钱，且为不定额时必填
     * ● 商品为微信红包时，且为不定额时必填
     */
    private Long transferAmount;

    /**
     * 转账备注
     * ● 商品为微信到零钱时，必填
     * ● 商品为微信红包时，为活动名称，必填
     */
    private String transferRemark;

    /**
     * 真实姓名
     */
    private String realName;

    /**
     * 姓名
     */
    private String name;

    /**
     * 充值手机号
     */
    private String phone;

    /**
     * 充值账号
     * ● 商品为油卡时有值
     */
    private String account;

    /**
     * 身份证号
     */
    private String idCard;
}
