package cn.com.duiba.quanyi.center.api.param.insurance.cdtb;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 保险成都太保权益表
 * @author mybatis generator 
 * @date 2024-09-25
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class InsuranceCdtbEquitySearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17272357868686315L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 保险公司ID，tb_insurance_company.id
     */
    private Long companyId;

    /**
     * 机构ID，tb_insurance_institution.id
     */
    private Long institutionId;

    /**
     * 权益ID, tb_insurance_equity.id
     */
    private Long equityId;

    /**
     * 坐席手机号
     */
    private String salesmanPhone;

    /**
     * 坐席姓名
     */
    private String salesmanName;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 保单号
     */
    private List<String> policyNos;

    /**
     * 坐席登录账号ID
     */
    private Long salesmanId;

    /**
     * 兑换状态：1-未兑换，2-部分兑换，3-已兑换
     */
    private Integer sendStatus;

    /**
     * 总金额，单位分
     */
    private Long totalAmount;

    /**
     * 代领人手机号
     */
    private String takePhone;

    /**
     * 代领人手机号(密文)
     */
    private String takePhoneEncrypt;

    /**
     * 文本备注
     */
    private String textRemark;

    /**
     * 第一次发放时间
     */
    private Date firstGrantTime;
}