package cn.com.duiba.quanyi.center.api.dto.insurance.cdtb;

import java.io.Serializable;
import java.util.Date;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

/**
 * 保险成都太保权益表
 * @author mybatis generator 
 * @date 2024-09-25
 */
@Data
public class InsuranceCdtbEquityDto implements Serializable {
     
    private static final long serialVersionUID = 17272357868678237L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;

    /**
     * 保险公司ID，tb_insurance_company.id
     */
    private Long companyId;

    /**
     * 机构ID，tb_insurance_institution.id
     */
    private Long institutionId;

    /**
     * 权益ID tb_insurance_equity.id
     */
    private Long equityId;

    /**
     * 坐席手机号
     */
    private String salesmanPhone;

    /**
     * 坐席姓名
     */
    private String salesmanName;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 坐席登录账号ID
     */
    private Long salesmanId;

    /**
     * 兑换状态：0-未发放 1-未兑换，2-部分兑换，3-已兑换
     */
    private Integer takeStatus;

    /**
     * 总金额，单位分
     */
    private Long totalAmount;

    /**
     * 已发放金额，单位分
     */
    private Long grantAmount;

    /**
     * 代领人手机号
     */
    private String takePhone;

    /**
     * 代领人手机号(密文)
     */
    private String takePhoneEncrypt;

    /**
     * 文本备注
     */
    private String textRemark;

    /**
     * 第一次发放时间
     */
    private Date firstGrantTime;

    /**
     * 机构名称
     */
    private String institutionName;
}