package cn.com.duiba.quanyi.center.api.param.mall.goods;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * 商品更新参数
 * @author xuzhigang
 * @date 2024/05/28
 */
@Data
public class MallGoodsUpdateParam implements Serializable {

    /**
     * ID
     */
    private Long id;

    /**
     * 商品名称
     */
    private String mallSpuName;

    /**
     * 商品缩略图
     */
    private String mainImgs;

    /**
     * 商品主图地址，多张图用英文 逗号 分割
     */
    private String detailImgs;

    /**
     * 图文详情
     */
    private String spuDesc;

    /**
     * sku列表
     */
    private List<MallGoodsSkuUpdateParam> skuList;
}
