package cn.com.duiba.quanyi.center.api.utils;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.tuple.Pair;

/**
 * @author lizhi
 * @date 2024/4/2 17:22
 */
@Slf4j
public class BatchTakeOrderNoUtils {
    
    private BatchTakeOrderNoUtils() {}
    
    public static String getBatchQueryOrderNo(String batchOrderNo, Integer goodsBizType) {
        return batchOrderNo + QuanYiStringUtils.toStringAndAddZero(goodsBizType.toString(), 2);
    }
    
    public static Pair<String, Integer> parseBatchQueryOrderNo(String batchQueryOrderNo) {
        return Pair.of(parseBatchOrderNo(batchQueryOrderNo), parseGoodsBizType(batchQueryOrderNo));
    }

    private static String parseBatchOrderNo(String batchQueryOrderNo) {
        try {
            return batchQueryOrderNo.substring(0, batchQueryOrderNo.length() - 2);
        } catch (Exception e) {
            log.error("[BatchTake], parse batchOrderNo error, batchQueryOrderNo={}", batchQueryOrderNo, e);
            return null;
        }
    }

    private static Integer parseGoodsBizType(String batchQueryOrderNo) {
        try {
            String typeStr = batchQueryOrderNo.substring(batchQueryOrderNo.length() - 2);
            return Integer.parseInt(typeStr);
        } catch (Exception e) {
            log.error("[BatchTake], parse goodsBizType error, batchQueryOrderNo={}", batchQueryOrderNo, e);
            return null;
        }
    }
}
