package cn.com.duiba.quanyi.center.api.enums.insurance;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * @author lizhi
 * @date 2024/3/4 14:36
 */
@Getter
@AllArgsConstructor
public enum InsuranceEquityVerifyStatusEnum {
    NOT_NEED(0, "无需验真"),
    NOT_VERIFY(1, "未验真"),
    PASS(2, "验真通过"),
    NO_PASS(3, "验真不通过"),
    AUDIT_PASS(4, "验真审核通过"),
    AUDIT_NOT_PASS(5, "验真审核不通过"),
    ;

    public static InsuranceEquityVerifyStatusEnum getByStatus(Integer status){
        for (InsuranceEquityVerifyStatusEnum verify : InsuranceEquityVerifyStatusEnum.values()){
            if (Objects.equals(verify.getStatus(), status)){
                return verify;
            }
        }
        return null;
    }
    
    private final Integer status;
    
    private final String desc;
}
