package cn.com.duiba.quanyi.center.api.remoteservice.qy.statement;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.statement.StatementDemandOfflineGoodsDto;
import cn.com.duiba.quanyi.center.api.dto.qy.statement.StatementDemandOfflineGoodsStatisticDto;
import cn.com.duiba.quanyi.center.api.param.qy.statement.StatementDemandOfflineGoodsSearchParam;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 结算单线下商品记录表
 * @author kjj mybatis generator 
 * @date 2024-09-27
 */
@AdvancedFeignClient
public interface RemoteStatementDemandOfflineGoodsService {


    /**
     * 根据需求ID查询统计结算的商品列表
     * @param demandId 需求ID
     * @return 结算单线下商品统计列表
     */
    List<StatementDemandOfflineGoodsStatisticDto> statisticByDemandId(Long demandId);

    /**
     * 根据需求ID和商品ID列表和日期查询已经结算的商品列表
     *
     * @param demandId        需求ID
     * @param goodsId         商品ID列表
     * @param startDate       开始日期
     * @param endDate         结束日期
     * @return 结算单中的线下商品
     */
    List<StatementDemandOfflineGoodsDto> selectByDemandIdAndGoodIdsAndDate(Long demandId, Set<Long> goodsId, Date startDate, Date endDate);

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 结算单线下商品记录集合
     */
    List<StatementDemandOfflineGoodsDto> selectPage(StatementDemandOfflineGoodsSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(StatementDemandOfflineGoodsSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 结算单线下商品记录
     */
    StatementDemandOfflineGoodsDto selectById(Long id);

    /**
     * 新增
     * @param dto 结算单线下商品记录
     * @return 执行结果
     */
    int insert(StatementDemandOfflineGoodsDto dto);

    /**
     * 更新
     * @param dto 结算单线下商品记录
     * @return 影响行数
     */
    int update(StatementDemandOfflineGoodsDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}