package cn.com.duiba.quanyi.center.api.param;

import lombok.Data;

import java.io.Serializable;

/**
 * 上传任务保存
 * @author lizhi
 * @date 2023/3/29 4:26 PM
 */
@Data
public class UploadTaskSaveParam implements Serializable {

    private static final long serialVersionUID = 6881266156086555707L;
    
    /**
     * 业务id
     */
    private Long bizId;

    /**
     * 业务类型 1-上传活动白名单 2-删除活动白名单
     * {@link cn.com.duiba.quanyi.center.api.enums.UploadBizTypeEnum}
     */
    private Integer bizType;

    /**
     * 操作人Id
     */
    private String operatorId;

    /**
     * 操作人姓名
     */
    private String operatorName;

    /**
     * 文件名称
     */
    private String fileName;

    /**
     * 备注
     */
    private String uploadRemark;

    /**
     * 源文件地址
     */
    private String uploadFileUrl;
}
