package cn.com.duiba.quanyi.center.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum DemandTypeEnum {
    CONVENTION_DEMAND(0, "常规需求"),
    OFFLINE_DEMAND(1, "线下需求"),
    ;
    private final Integer code;

    private final String desc;

    /**
     * 根据code获取描述
     * @param code
     * @return
     */
    public static String getDesc(Integer code) {
        for (DemandTypeEnum demandTypeEnum : values()) {
            if (demandTypeEnum.getCode().equals(code)) {
                return demandTypeEnum.getDesc();
            }
        }
        return null;
    }
}
