package cn.com.duiba.quanyi.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.WxCouponAutoCreateTaskDto;
import cn.com.duiba.quanyi.center.api.param.coupon.WxCouponAutoCreateTaskSearchParam;

import java.util.List;

/**
 * 微信立减金自动创建批次任务表
 * @author kjj mybatis generator 
 * @date 2024-03-25
 */
@AdvancedFeignClient
public interface RemoteWxCouponAutoCreateTaskService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 微信立减金自动创建批次任务集合
     */
    List<WxCouponAutoCreateTaskDto> selectPage(WxCouponAutoCreateTaskSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(WxCouponAutoCreateTaskSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 微信立减金自动创建批次任务
     */
    WxCouponAutoCreateTaskDto selectById(Long id);

    /**
     * 新增
     * @param dto 微信立减金自动创建批次任务
     * @return 执行结果
     */
    int insert(WxCouponAutoCreateTaskDto dto);

    /**
     * 更新
     * @param dto 微信立减金自动创建批次任务
     * @return 影响行数
     */
    int update(WxCouponAutoCreateTaskDto dto);

    /**
     * 根据偏移量查询
     *
     * @param taskId   任务ID
     * @param pageSize 分页大小
     * @param lastId   最后一个ID
     * @return 结果
     */
    List<WxCouponAutoCreateTaskDto> selectByOffset(Long taskId, int pageSize, Long lastId);
}