package cn.com.duiba.quanyi.center.api.param.activity;

import cn.com.duiba.quanyi.center.api.enums.pay.PayChannelTypeEnum;
import cn.com.duiba.quanyi.center.api.param.pay.ext.WxLiteCreateOrderParam;
import cn.com.duiba.quanyi.center.api.param.pay.ext.WxMpCreateOrderParam;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author: LuHui
 * @date: 2024/7/19 17:57
 * @description:
 */
@Data
public class ActivityTemplatePayCreateOrderParam implements Serializable {
    private static final long serialVersionUID = 7538669342767904113L;
    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 小程序appId
     */
    private String appId;

    /**
     * 支付渠道
     * @see cn.com.duiba.quanyi.center.api.enums.pay.PayChannelTypeEnum
     */
    private String payChannelType = PayChannelTypeEnum.WX_LITE.getChannelType();

    /**
     * 页面展示需要支付的金额
     */
    private Long pageAmount;
    /**
     * 奖品ID
     */
    private List<Long> prizeIdList;

    /**
     * 微信小程序支付参数
     */
    private WxLiteCreateOrderParam wxLite;
    /**
     * 微信公众号支付参数
     */
    private WxMpCreateOrderParam wxMp;
}
