package cn.com.duiba.quanyi.center.api.remoteservice.insurance.equity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.activity.InsuranceTakeBaseResultDto;
import cn.com.duiba.quanyi.center.api.dto.insurance.equity.InsuranceEquityDto;
import cn.com.duiba.quanyi.center.api.dto.insurance.equity.InsuranceEquitySaveOrUpdateDto;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceEquityCarSerEditNotTakeNumParam;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceEquityCarSerEditParam;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceEquitySearchParam;
import java.util.List;

/**
 * 保司权益表
 * @author kjj mybatis generator 
 * @date 2024-03-04
 */
@AdvancedFeignClient
public interface RemoteInsuranceEquityService {

    /**
     * 税率
     * @return 税率
     */
    String taxRate();

    /**
     * 权益二批次发放时间为创建时间的多少分钟后
     * @return 分钟
     */
    int grantMinutes();
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 保司权益集合
     */
    List<InsuranceEquityDto> selectPage(InsuranceEquitySearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InsuranceEquitySearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 保司权益
     */
    InsuranceEquityDto selectById(Long id);

    /**
     * 根据ID 批量查询
     * @param ids ID集合
     * @return 保司权益
     */
    List<InsuranceEquityDto> selectByIds(List<Long> ids);

    /**
     * 新增权益
     * @param dto 新增参数
     * @return 主键
     */
    InsuranceTakeBaseResultDto<Long> save(InsuranceEquitySaveOrUpdateDto dto);

    /**
     * 更新权益
     * @param dto 更新参数
     * @return 主键
     */
    InsuranceTakeBaseResultDto<Long> update(InsuranceEquitySaveOrUpdateDto dto);

    /**
     * 删除权益
     * @param id 主键
     * @param operatorPhone 操作人手机号
     * @return 是否成功
     */
    InsuranceTakeBaseResultDto<Boolean> delete(Long id, String operatorPhone);

    /**
     * 根据手机号查询权益
     * @param accountPhone 手机号
     * @return
     */
    List<InsuranceEquityDto> selectByAccountPhone(String accountPhone);


    /**
     * 更新审核状态
     * @param id
     * @param auditStatus
     * @return
     */
    int updateAuditStatus(Long id, int auditStatus);



    /**
     * 更新审核验真状态
     * @param id
     * @param verifyStatus
     * @return
     */
    int updateVerifyStatus(Long id, int verifyStatus);

    InsuranceTakeBaseResultDto<Long> updateEquityInfo(InsuranceEquitySaveOrUpdateDto dto);

//    /**
//     * 更新审核状态
//     * @param id
//     * @param auditStatus
//     * @param operatorPhone
//     * @return
//     */
//    int updateAuditStatus(Long id, int auditStatus, String operatorPhone);
//
//
//
//    /**
//     * 更新审核验真状态
//     * @param id
//     * @param verifyStatus
//     * @param operatorPhone
//     * @return
//     */
//    int updateVerifyStatus(Long id, int verifyStatus, String operatorPhone);


    /**
     * 兑换退回
     * @param takeBizNo 业务单号
     * @param accountPhone 手机号
     * @param refundOrderNo 退款单号
     * @param refundAmount 退款金额
     * @throws BizException 退回失败抛出异常
     */
    void takeRefund(String takeBizNo, String accountPhone, String refundOrderNo, Long refundAmount) throws BizException;

    /**
     * 发放车服权益
     * @param dto 权益信息
     * @return 发放结果
     */
    InsuranceTakeBaseResultDto<Long> saveCarSerEquity(InsuranceEquitySaveOrUpdateDto dto);

    /**
     * 删除车服权益
     * @param id 权益id
     * @return 删除结果
     */
    InsuranceTakeBaseResultDto<Boolean> deleteCarSerEquity(Long id);

    /**
     * 编辑车服权益
     * @param param 编辑参数
     * @return 编辑参数
     */
    InsuranceTakeBaseResultDto<Boolean> editCarSerEquity(InsuranceEquityCarSerEditParam param);

    /**
     * 编辑车服权益数量（只能编辑未兑换的部分）
     * @param param  编辑参数
     * @return 删除结果
     */
    InsuranceTakeBaseResultDto<Boolean> editCarSerNotTakeNum(InsuranceEquityCarSerEditNotTakeNumParam param);
}