package cn.com.duiba.quanyi.center.api.enums.coupon.autocreate.alipay;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * @author xuzhigang
 * @date 2024/7/31 15:58
 **/
@Getter
@AllArgsConstructor
public enum GamePlayTypeEnum {
    GAME_PLAY_SINGLE(1, "单一门槛优惠"),
    GAME_PLAY_STEP(2, "阶梯门槛优惠"),
    ;

    private Integer code;
    private String desc;

    public static GamePlayTypeEnum getByCode(Integer code) {
        return Arrays.stream(GamePlayTypeEnum.values()).filter(o -> Objects.equals(code, o.getCode())).findFirst().orElse(null);
    }
}
