/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.utils;

import cn.com.duiba.quanyi.center.api.utils.QuanYiStringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchTakeOrderNoUtils {
    private static final Logger log = LoggerFactory.getLogger(BatchTakeOrderNoUtils.class);

    private BatchTakeOrderNoUtils() {
    }

    public static String getBatchQueryOrderNo(String batchOrderNo, Integer goodsBizType) {
        return batchOrderNo + QuanYiStringUtils.toStringAndAddZero(goodsBizType.toString(), 2);
    }

    public static Pair<String, Integer> parseBatchQueryOrderNo(String batchQueryOrderNo) {
        return Pair.of((Object)BatchTakeOrderNoUtils.parseBatchOrderNo(batchQueryOrderNo), (Object)BatchTakeOrderNoUtils.parseGoodsBizType(batchQueryOrderNo));
    }

    private static String parseBatchOrderNo(String batchQueryOrderNo) {
        try {
            return batchQueryOrderNo.substring(0, batchQueryOrderNo.length() - 2);
        }
        catch (Exception e) {
            log.error("[BatchTake], parse batchOrderNo error, batchQueryOrderNo={}", (Object)batchQueryOrderNo, (Object)e);
            return null;
        }
    }

    private static Integer parseGoodsBizType(String batchQueryOrderNo) {
        try {
            String typeStr = batchQueryOrderNo.substring(batchQueryOrderNo.length() - 2);
            return Integer.parseInt(typeStr);
        }
        catch (Exception e) {
            log.error("[BatchTake], parse goodsBizType error, batchQueryOrderNo={}", (Object)batchQueryOrderNo, (Object)e);
            return null;
        }
    }
}

