package cn.com.duiba.quanyi.center.api.enums.taibao.cq;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhi
 * @date 2025/1/23 14:37
 */
@Getter
@AllArgsConstructor
public enum CqtbSubOrderStatusEnum {
    /**
     * 单日超过1000的部分，未激活的订单
     * 备注：微信限额1000/天，超过1000的部分待激活状态，递延次日自动激活可领取
     */
    NOT_ACTIVE(1, "未激活：单日超1000，次日自动推送超额部分", true),
    /**
     * 处理中（内部异步状态）
     */
    PROCESSING(2, "处理中", false),
    /**
     * 已经推送服务通知，但是用户还未点击领取红包
     */
    GRANT(3, "已发放待领取：已推送待领取", true),
    /**
     * 用户在服务通知领取了红包
     */
    SUCCESS(4, "已领取：已领取", true),
    /**
     * 红包过期
     */
    EXPIRED(5, "发放异常（待补发）：已过期待补发", true),
    /**
     * 订单发放失败的其他情况（不是过期未领取的情况）
     * 备注：%s-具体的异常描述
     * 特殊状态，极少。
     * 微信异常说明:
     * 平台异常：请联系服务商确认异常原因，解除异常后可操作补发；
     * 微信风控：风险请求，被微信拦截，请解除微信风险或者更换微信账号后可操作补发；
     * 账户异常：微信账户收款异常，请解除异常或者更换微信账号后可操作补发
     * 过期未领：红包超过24h未领取且系统已经自动补发两次，可手动补发
     * 其他异常：订单异常，可手动补发
     */
    EXCEPTION(6, "发放异常（其他）：异常待人工处理（%s）", true),
    /**
     * 点击停止补发功能按钮
     */
    CLOSE(7, "发放异常（不补发）：手动停止补发", true),
    ;

    /**
     * 数据库存储值
     */
    private final Integer code;

    /**
     * 返回给太保的msg(状态+中文冒号+msg反馈内容)
     */
    private final String msg;

    /**
     * 接口返回的状态
     */
    private final boolean status;
}
