package cn.com.duiba.quanyi.center.api.remoteservice.settlement;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.settlement.SettlementNumStatDto;

/**
 * 结算单数量统计数据
 * @author kjj mybatis generator 
 * @date 2024-11-30
 */
@AdvancedFeignClient
public interface RemoteSettlementNumStatService {

    /**
     * 根据统计ID查询
     * @param statType 统计类型
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.SettlementStatTypeEnum
     * @param statId 统计ID
     * @return 结算单数量统计数据
     */
    SettlementNumStatDto selectByStat(Integer statType, Long statId);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 结算单数量统计数据
     */
    SettlementNumStatDto selectById(Long id);
}