package cn.com.duiba.quanyi.center.api.remoteservice.taibao.cq;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.taibao.cq.CqtbApiOrderSubDto;
import cn.com.duiba.quanyi.center.api.param.taibao.cq.CqtbApiOrderSubSearchParam;

import java.util.Date;
import java.util.List;

/**
 * 重庆太保定制-API供货子订单表
 * @author kjj mybatis generator 
 * @date 2025-01-21
 */
@AdvancedFeignClient
public interface RemoteCqtbApiOrderSubService {

    /**
     * 分页查询
     * @param param 分页参数
     * @return 重庆太保定制-API供货子订单
     */
    List<CqtbApiOrderSubDto> selectPageByPreSendDate(CqtbApiOrderSubSearchParam param);

    /**
     * 根据openId及预计发送时间查询
     * @param wxOpenId 微信openId
     * @param startPreSendDate 预计发送时间(开始时间)
     * @return 重庆太保定制-API供货子订单
     */
    List<CqtbApiOrderSubDto> selectByOpenId(String wxOpenId, Date startPreSendDate);

    /**
     * 更新状态
     * @param id 主键
     * @param fromStatus 原状态
     * @param toStatus 最新状态
     * @return 执行结果
     */
    int updateStatus(Long id, Integer fromStatus, Integer toStatus);
}