package cn.com.duiba.quanyi.center.api.remoteservice.qy.boc;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.boc.BocUserExtDto;
import cn.com.duiba.quanyi.center.api.param.qy.boc.BocUserExtSearchParam;
import java.util.List;

/**
 * 中行客户信息表
 * @author kjj mybatis generator 
 * @date 2025-01-09
 */
@AdvancedFeignClient
public interface RemoteBocUserExtService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 中行客户信息集合
     */
    List<BocUserExtDto> selectPage(BocUserExtSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(BocUserExtSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 中行客户信息
     */
    BocUserExtDto selectById(Long id);

    /**
     * 新增
     * @param dto 中行客户信息
     * @return 执行结果
     */
    int insert(BocUserExtDto dto);

    /**
     * 更新
     * @param dto 中行客户信息
     * @return 影响行数
     */
    int update(BocUserExtDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据用户ID唯一键查询
     * @param userId 主键
     * @return 中行客户信息
     */
    BocUserExtDto selectByUserId(Long userId);
}