package cn.com.duiba.quanyi.center.api.remoteservice.taibao.cq;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.taibao.cq.CqtbApiOrderDetailDto;
import cn.com.duiba.quanyi.center.api.dto.taibao.cq.CqtbApiOrderDto;

/**
 * 重庆太保定制-API供货主订单表
 * @author kjj mybatis generator 
 * @date 2025-01-21
 */
@AdvancedFeignClient
public interface RemoteCqtbApiOrderService {

    /**
     * 根据太保单号查询
     * @param thirdOrderId 太保单号
     * @return 重庆太保定制-API供货主订单
     */
    CqtbApiOrderDto selectByThirdOrderId(String thirdOrderId);

    /**
     * 新增
     * @param detailDto 订单
     * @return 添加结果，失败返回null
     */
    CqtbApiOrderDto add(CqtbApiOrderDetailDto detailDto);

    /**
     * 更新状态，并写入推送记录
     * @param id 主键
     * @param fromStatus 原状态
     * @param toStatus 最新状态
     * @return 执行结果
     */
    int updateStatusAndSavePush(Long id, Integer fromStatus, Integer toStatus);

    /**
     * 写入推送记录
     * @param id 主键
     * @param notifyJson 推送明文json
     * @return 执行结果
     */
    int savePush(Long id, String notifyJson);
}