package cn.com.duiba.quanyi.center.api.remoteservice.settlement.receive;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.BaseResultDto;
import cn.com.duiba.quanyi.center.api.dto.settlement.receive.ReceivedPaymentDto;
import cn.com.duiba.quanyi.center.api.param.settlement.receive.ReceivedPaymentAssociationParam;
import cn.com.duiba.quanyi.center.api.param.settlement.receive.ReceivedPaymentDisassociationParam;
import cn.com.duiba.quanyi.center.api.param.settlement.receive.ReceivedPaymentSearchParam;

import java.util.List;
import java.util.Set;

/**
 * 回款
 * @author kjj mybatis generator 
 * @date 2024-12-11
 */
@AdvancedFeignClient
public interface RemoteReceivedPaymentService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 回款集合
     */
    List<ReceivedPaymentDto> selectPage(ReceivedPaymentSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ReceivedPaymentSearchParam param);

    /**
     * 根据主键查询
     * @param ids 主键
     * @return 回款
     */
    List<ReceivedPaymentDto> selectByIds(Set<Long> ids);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 回款
     */
    ReceivedPaymentDto selectById(Long id);

    /**
     * 批量新增
     * @param list 回款
     * @return 回填ID后的回款信息
     */
    List<ReceivedPaymentDto> batchInsert(List<ReceivedPaymentDto> list);

    /**
     * 修改商务
     * @param id 主键
     * @param commerceId 商务ssoId
     * @param commerceName 商务名称
     * @return 执行结果
     */
    int updateCommerce(Long id, Long commerceId, String commerceName);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 批量关联
     * @param param 关联参数
     * @return 记录ID
     */
    BaseResultDto<Long> association(ReceivedPaymentAssociationParam param);

    /**
     * 批量取消关联
     * @param param 取消关联参数
     * @return 记录ID
     */
    BaseResultDto<Long> disassociation(ReceivedPaymentDisassociationParam param);
}