package cn.com.duiba.quanyi.center.api.remoteservice.settlement.receive;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.settlement.receive.ReceivedPaymentSubjectDto;
import cn.com.duiba.quanyi.center.api.param.settlement.receive.ReceivedPaymentSubjectSearchParam;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 回款-打款主体
 * @author kjj mybatis generator 
 * @date 2024-12-19
 */
@AdvancedFeignClient
public interface RemoteReceivedPaymentSubjectService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 回款-打款主体集合
     */
    List<ReceivedPaymentSubjectDto> selectPage(ReceivedPaymentSubjectSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ReceivedPaymentSubjectSearchParam param);

    /**
     * 查询存在的打款主体
     * @param subjects 打款主体
     * @return key：打款主体，value：主键
     */
    Map<String, Long> selectExistSubjectMap(Set<String> subjects);

    /**
     * 批量写入
     * @param list 回款-打款主体集合
     * @return key：打款主体，value：主键
     */
    Map<String, Long> batchInsert(Set<String> list);
}