package cn.com.duiba.quanyi.center.api.remoteservice.taibao.cq;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.taibao.cq.CqtbApiOrderSubDto;
import cn.com.duiba.quanyi.center.api.param.taibao.cq.CqtbApiOrderSubSearchParam;

import java.util.Date;
import java.util.List;

/**
 * 重庆太保定制-API供货子订单表
 * @author kjj mybatis generator 
 * @date 2025-01-21
 */
@AdvancedFeignClient
public interface RemoteCqtbApiOrderSubService {

    /**
     * 分页查询
     * @param param 分页参数
     * @return 重庆太保定制-API供货子订单
     */
    List<CqtbApiOrderSubDto> selectPageByPreSendDate(CqtbApiOrderSubSearchParam param);

    /**
     * 根据订单状态、预计发放时间查询符合条件的数量
     * @param orderStatus 订单状态
     * @see cn.com.duiba.quanyi.center.api.enums.taibao.cq.CqtbSubOrderStatusEnum
     * @param endPreSendDate 预计发送时间-结束时间
     * @return 符合条件的数量
     */
    long selectCountByStatusPreSendDate(Integer orderStatus, Date endPreSendDate);

    /**
     * 根据openId及预计发送时间查询
     * @param wxOpenId 微信openId
     * @param startPreSendDate 预计发送时间(开始时间)
     * @return 重庆太保定制-API供货子订单
     */
    List<CqtbApiOrderSubDto> selectByOpenId(String wxOpenId, Date startPreSendDate);

    /**
     * 根据太保单号查询
     * @param thirdOrderId 太保单号
     * @return 重庆太保定制-API供货子订单
     */
    List<CqtbApiOrderSubDto> selectByThirdOrderId(String thirdOrderId);

    /**
     * 根据子订单查询
     * @param subNo 子订单
     * @return 子订单
     */
    CqtbApiOrderSubDto selectBySubNo(String subNo);

    /**
     * 更新状态，并写入推送记录
     * @param id 主键
     * @param fromStatus 原状态
     * @param toStatus 最新状态
     * @param errMsg 错误原因
     * @param lqTime 领取时间
     * @param subNo 子订单
     * @return 执行结果
     */
    boolean updateStatusAndSavePush(Long id, Integer fromStatus, Integer toStatus, String errMsg, Date lqTime, String subNo);
}