package cn.com.duiba.quanyi.center.api.param.activity;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 活动业务关联关系表
 * @author mybatis generator 
 * @date 2025-02-13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class ActivityBizRelationSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17394180291014785L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 业务类型
     */
    private String bizType;

    /**
     * 活动ID（无关联活动ID为-1）
     */
    private Long activityId;

    /**
     * 业务ID
     */
    private String bizId;

    /**
     * 业务内容
     */
    private String bizContext;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 额外信息
     */
    private String extraJson;
}