package cn.com.duiba.quanyi.center.api.param.coupon;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * AlipayActivitySaveOrUpdateParam
 * @author yangyukang
 */
@Data
@ToString
public class AlipayCountCoinsActivitySaveOrUpdateParam implements Serializable {

    private static final long serialVersionUID = -7721521073173220104L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 总库存
     */
    private Long totalNum;

    /**
     * 支付宝分配给开发者的应用ID
     */
    private String alipayAppId;

    /**
     * 支付宝数币活动名称
     */
    private String countCoinsName;

    /**
     * 支付宝数币活动ID
     */
    private String alipayActId;

    /**
     * 支付宝数币活动状态
     */
    private Integer alipayActStatus;

    /**
     * 优惠立减值, 分为单位如果discount_type=single，那么就是具体的优惠立减额，比如：999代表满足一定金额减9.99元；如果是其他类型，存储JSON字符串
     */
    private Long discountValue;

    /**
     * 优惠立减门槛金额 以分为单位
     */
    private Long discountThresholdAmt;

    /**
     * 发放开始时间
     */
    private Date startTime;

    /**
     * 发放结束时间
     */
    private Date endTime;

    /**
     * 总预算
     */
    private Long totalBudget;

    /**
     * 活动规则
     */
    private String activityRule;

    /**
     * 创建人操作Id,ssoid
     */
    private Long createOperatorId;

    /**
     * 创建人操作Id,ssoname
     */
    private String createOperatorName;

    /**
     * 需求主键, tb_demand.id
     */
    private Long demandId;

    /**
     * 采购商品主键, tb_purchase_goods.id
     */
    private Long demandGoodsId;

    /**
     * 商品规格ID
     */
    private Long skuId;

    /**
     * 短链前端页面ID
     */
    private String pageId;

}
