package cn.com.duiba.quanyi.center.api.remoteservice.api;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.ApiOrderPushSuccessRecordDto;
import cn.com.duiba.quanyi.center.api.param.qy.ApiOrderPushSuccessRecordSearchParam;
import java.util.List;

/**
 * API供货订单推送成功记录表
 * @author kjj mybatis generator 
 * @date 2025-02-25
 */
@AdvancedFeignClient
public interface RemoteApiOrderPushSuccessRecordService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return API供货订单推送成功记录集合
     */
    List<ApiOrderPushSuccessRecordDto> selectPage(ApiOrderPushSuccessRecordSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ApiOrderPushSuccessRecordSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return API供货订单推送成功记录
     */
    ApiOrderPushSuccessRecordDto selectById(Long id);

    /**
     * 新增
     * @param dto API供货订单推送成功记录
     * @return 执行结果
     */
    int insert(ApiOrderPushSuccessRecordDto dto);

    /**
     * 更新
     * @param dto API供货订单推送成功记录
     * @return 影响行数
     */
    int update(ApiOrderPushSuccessRecordDto dto);   

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 批量新增
     * @param list list
     * @return 执行结果
     */
    int batchInsert(List<ApiOrderPushSuccessRecordDto> list);
}