package cn.com.duiba.quanyi.center.api.dto.contract;

import java.io.Serializable;
import java.util.Date;

import cn.com.duiba.quanyi.center.api.enums.project.BelongingBusinessTypeEnum;
import lombok.Data;

/**
 * 合同表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@Data
public class ContractDto implements Serializable {

    private static final long serialVersionUID = 4839906531083624544L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 合同名称
     */
    private String contractName;

    /**
     * 合作客户主键, tb_partner.id
     */
    private Long partnerId;

    /**
     * 合同编号
     */
    private String contractCode;

    /**
     * 合同文件地址
     */
    private String contractFile;

    /**
     * 消耗类型, 1-框架，2-预算
     *
     * @see cn.com.duiba.quanyi.center.api.enums.contract.ContractConsumeTypeEnum
     */
    private Integer consumeType;

    /**
     * 消耗上限
     */
    private String consumeDesc;

    /**
     * 合作开始时间
     */
    private Date startTime;

    /**
     * 合作结束时间
     */
    private Date endTime;

    /**
     * 合同运营，多个以英文逗号分隔
     */
    private String contractOperations;

    /**
     * 合同商务，多个以英文逗号分隔
     */
    private String contractCommerce;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
    /**
     * 创建人id
     */
    private Long createOperatorId;
    /**
     * 创建人名称
     */
    private String createOperatorName;
    /**
     * 纷享销客合同号
     */
    private String salesContractNumber;

    /**
     * 业务主体
     * 
     * @see cn.com.duiba.quanyi.goods.service.api.enums.subject.SubjectEnum
     */
    private Long duibaSubject;

    /**
     * 项目id
     */
    private Long projectId;

    /**
     * 合同ID 创建日期+编号
     */
    private String contractNo;

    /**
     * 合同类型1-权益主合同 2-权益附属合同
     * 
     * @see cn.com.duiba.quanyi.center.api.enums.contract.ContractTypeEnum
     */
    private Integer contractType;

    /**
     * 客户签订主体
     */
    private String partnerSubject;

    /**
     * 关联主合同 合同类型为权益附属合同时有值
     */
    private Long mainContractId;

    /**
     * 所属业务
     * 
     * @see BelongingBusinessTypeEnum#getType()
     */
    private Integer belongingBusiness;

    /**
     * 合同附件
     */
    private String contractAttachments;

    /**
     * 合同备注
     */
    private String contractRemark;

    /**
     * 合作金额 单位分
     */
    private Long cooperationAmount;

    /**
     * 归档类型
     * 
     * @see cn.com.duiba.quanyi.center.api.enums.contract.ArchiveTypeEnum
     */
    private Integer archiveType;

    /**
     * 是否需要打印 0-不需要 1-需要
     */
    private Integer needPrint;

    /**
     * 盖章类型
     * 
     * @see cn.com.duiba.quanyi.center.api.enums.contract.StampTypeEnum
     */
    private String stampTypes;

    /**
     * 归档日期
     */
    private Date archiveDate;

    /**
     * 钉钉审批流状态
     */
    private Integer approvalStatus;

    /**
     * 合同状态
     * 
     * @see cn.com.duiba.quanyi.center.api.enums.contract.ContractStatusEnum
     */
    private Integer contractStatus;

    /**
     * 审批拒绝原因
     */
    private String approvalRejectReason;

    /**
     * 剩余合同金额，单位分
     */
    private Long surplusAmount;
}