package cn.com.duiba.quanyi.center.api.dto.contract;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 合同库存变更记录DTO
 *
 * @author xuzhigang
 * @date 2025-06-06
 */
@Data
public class ContractStockChangeRecordDto implements Serializable {

    private static final long serialVersionUID = 923456789012345679L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 合同id tb_contract.id
     */
    private Long contractId;

    /**
     * 变更前合同剩余金额
     */
    private Long originSurplusAmount;

    /**
     * 变更后合同剩余金额
     */
    private Long changeSurplusAmount;

    /**
     * 变更类型 1-合同金额变更
     */
    private Integer changeType;

    /**
     * 操作人ssoId
     */
    private Long operatorSsoId;

    /**
     * 操作人sso姓名
     */
    private String operatorSsoName;

    /**
     * 变更备注
     */
    private String changeRemark;
} 