package cn.com.duiba.quanyi.center.api.param.contract;

import java.io.Serializable;

import lombok.Data;

/**
 * 合同库存金额更新参数
 *
 * @author xuzhigang
 * @date 2025-1-3
 */
@Data
public class ContractStockAmountUpdateParam implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 合同ID
     */
    private Long contractId;

    /**
     * 减少的金额（正数表示减少，负数表示增加）
     */
    private Long decreaseAmount;

    /**
     * 版本号（乐观锁版本控制）
     */
    private Integer lockVersion;

    public ContractStockAmountUpdateParam() {}

    public ContractStockAmountUpdateParam(Long contractId, Long decreaseAmount, Integer lockVersion) {
        this.contractId = contractId;
        this.decreaseAmount = decreaseAmount;
        this.lockVersion = lockVersion;
    }
} 