package cn.com.duiba.quanyi.center.api.remoteservice.contract;

import java.util.List;
import java.util.Set;

import cn.com.duiba.quanyi.center.api.dto.contract.ContractConsumeStatDto;

/**
 * 合同消耗统计RemoteService
 *
 * @author xuzhigang
 * @date 2025-06-06
 */
public interface RemoteContractConsumeStatService {

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 合同消耗统计
     */
    ContractConsumeStatDto selectById(Long id);

    /**
     * 根据统计ID和统计类型查询
     *
     * @param statId   统计ID
     * @param statType 统计类型
     * @return 合同消耗统计
     */
    ContractConsumeStatDto selectByStatIdAndType(Long statId, Integer statType);

    /**
     * 根据多个统计ID和指定统计类型查询
     *
     * @param statIds  统计ID集合
     * @param statType 统计类型
     * @return 合同消耗统计列表
     */
    List<ContractConsumeStatDto> selectByStatIdsAndType(Set<Long> statIds, Integer statType);

    /**
     * 根据是否超额查询
     *
     * @param hasOverAmount 是否超额 0-未超额 1-已超额
     * @return 合同消耗统计列表
     */
    List<ContractConsumeStatDto> selectByHasOverAmount(Integer hasOverAmount);

    /**
     * 根据统计类型和是否超额查询
     *
     * @param statType      统计类型
     * @param hasOverAmount 是否超额 0-未超额 1-已超额
     * @return 合同消耗统计列表
     */
    List<ContractConsumeStatDto> selectByStatTypeAndHasOverAmount(Integer statType, Integer hasOverAmount);

    /**
     * 新增
     *
     * @param dto 合同消耗统计
     * @return 执行结果
     */
    int insert(ContractConsumeStatDto dto);

    /**
     * 更新
     *
     * @param dto 合同消耗统计
     * @return 执行结果
     */
    int update(ContractConsumeStatDto dto);

    /**
     * 根据统计ID和类型更新是否超额状态
     *
     * @param statId        统计ID
     * @param statType      统计类型
     * @param hasOverAmount 是否超额 0-未超额 1-已超额
     * @return 执行结果
     */
    int updateHasOverAmountByStatIdAndType(Long statId, Integer statType, Integer hasOverAmount);
} 