package cn.com.duiba.quanyi.center.api.dto.demand;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 需求商品消耗预算变更记录传输对象
 *
 * @author xuzhigang
 * @date 2025-6-3
 */
@Data
public class DemandGoodsConsumeBudgetChangeRecordDto implements Serializable {

    private static final long serialVersionUID = 3847523962184756203L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 需求商品id tb_demand_goods.id
     */
    private Long demandGoodsId;

    /**
     * 修改前消耗预算
     */
    private Long originConsumeBudget;

    /**
     * 修改后消耗预算
     */
    private Long changeConsumeBudget;

    /**
     * 操作人ssoId
     */
    private Long operatorSsoId;

    /**
     * 操作人sso姓名
     */
    private String operatorSsoName;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}
