package cn.com.duiba.quanyi.center.api.remoteservice.contract;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.contract.ContractStockChangeRecordDto;

/**
 * 合同库存变更记录RemoteService
 *
 * @author xuzhigang
 * @date 2025-06-06
 */
@AdvancedFeignClient
public interface RemoteContractStockChangeRecordService {

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 合同库存变更记录
     */
    ContractStockChangeRecordDto selectById(Long id);

    /**
     * 根据合同ID查询
     *
     * @param contractId 合同ID
     * @return 合同库存变更记录列表
     */
    List<ContractStockChangeRecordDto> selectByContractId(Long contractId);

    /**
     * 新增
     *
     * @param dto 合同库存变更记录
     * @return 执行结果
     */
    int insert(ContractStockChangeRecordDto dto);

    /**
     * 更新
     *
     * @param dto 合同库存变更记录
     * @return 执行结果
     */
    int update(ContractStockChangeRecordDto dto);
}
